//
//  VIDEOkit.m
//  HelloWorld
//
//  Created by Erica Sadun on 5/12/10.
//  Copyright 2010 Up To No Good, Inc. All rights reserved.
//

#import "VIDEOkit.h"

#define SAFE_PERFORM_WITH_ARG(THE_OBJECT, THE_SELECTOR, THE_ARG) (([THE_OBJECT respondsToSelector:THE_SELECTOR]) ? [THE_OBJECT performSelector:THE_SELECTOR withObject:THE_ARG] : nil)

#define SCREEN_CONNECTED	([UIScreen screens].count > 1)

@implementation VIDEOkit
@synthesize delegate;
@synthesize outwindow, displayLink;

static VIDEOkit *sharedInstance = nil;

- (void) setupExternalScreen
{
	// Sprawdzenie w poszukiwaniu brakujących ekranów.
	if (!SCREEN_CONNECTED) return;
	
	// Konfiguracja ekranu zewnętrznego.
	UIScreen *secondaryScreen = [[UIScreen screens] objectAtIndex:1];
	UIScreenMode *screenMode = [[secondaryScreen availableModes] lastObject];
	CGRect rect = (CGRect){.size = screenMode.size};
	NSLog(@"Wielkość ekranu zewnętrznego: %@", NSStringFromCGSize(rect.size));
	
	// Utworzenie nowego okna.
	self.outwindow = [[UIWindow alloc] initWithFrame:CGRectZero];
	outwindow.screen = secondaryScreen;
	outwindow.screen.currentMode = screenMode; // Podziękowania dla Scotta Lawrence'a.
	[outwindow makeKeyAndVisible];
	outwindow.frame = rect;

	// Dodanie do okna podstawowego widoku.
	baseView = [[UIImageView alloc] initWithFrame:rect];
	baseView.backgroundColor = [UIColor darkGrayColor];
	[outwindow addSubview:baseView];

	// Ustawienie jako okno główne.
	[delegate.view.window makeKeyAndVisible];
}

- (void) updateScreen
{
	// Przerwanie, jeśli ekran został odłączony.
	if (!SCREEN_CONNECTED && outwindow)
		self.outwindow = nil;
	
	// (Ponowna) inicjalizacja, jeśli nie ma okna na ekranie zewnętrznym.
	if (SCREEN_CONNECTED && !outwindow)
		[self setupExternalScreen];
	
	// Przerwanie w przypadku napotkania dziwnego błędu.
	if (!self.outwindow) return;
	
	// Przeprowadzenie uaktualnienia.
    SAFE_PERFORM_WITH_ARG(delegate, @selector(updateExternalView:), baseView);
}

- (void) screenDidConnect: (NSNotification *) notification
{
    NSLog(@"Ekran podłączony");
    UIScreen *screen = [[UIScreen screens] lastObject];
    
    if (displayLink)
    {
        [displayLink removeFromRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
        [displayLink invalidate];
        self.displayLink = nil;
    }
    
    // Sprawdzenie istnienia obiektu DisplayLink.
    if (!displayLink)
    {
        self.displayLink = [screen displayLinkWithTarget:self selector:@selector(updateScreen)];
        [displayLink addToRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
    }
}

- (void) screenDidDisconnect: (NSNotification *) notification
{
	NSLog(@"Ekran został odłączony.");
    if (displayLink)
    {
        [displayLink removeFromRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
        [displayLink invalidate];
        self.displayLink = nil;
    }
}

- (id) init
{
	if (!(self = [super init])) return self;
	
	// Obsługa utworzenia okna na ekranie zewnętrznym.
	if (SCREEN_CONNECTED) 
        [self screenDidConnect:nil];
	
	// Rejestracja powiadomień informujących o podłączeniu lub odłączeniu ekranu.
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(screenDidConnect:) name:UIScreenDidConnectNotification object:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(screenDidDisconnect:) name:UIScreenDidDisconnectNotification object:nil];

	return self;
}

- (void) dealloc
{
    [self screenDidDisconnect:nil];
	self.outwindow = nil;
}

+ (VIDEOkit *) sharedInstance
{
	if (!sharedInstance)	
		sharedInstance = [[self alloc] init];
	return sharedInstance;
}

+ (void) startupWithDelegate: (id) aDelegate
{
    [[self sharedInstance] setDelegate:aDelegate];
}
@end
